﻿using System;
using System.ComponentModel;
using System.Web.UI.WebControls;

using Framework.Data;
using Framework.Web;

namespace Framework.Web.UI
{
    /// <summary>
    /// TemplateFieldの機能拡張版
    /// </summary>
    public class LTemplateField : System.Web.UI.WebControls.TemplateField
    {
        /// <summary>
        /// ヘッダに表示するテキストのテキストキー
        /// </summary>
        public string HeaderLTextKey { get; set; }

        /// <summary>
        /// フッタに表示するテキストのテキストキー
        /// </summary>
        public string FooterLTextKey { get; set; }

        /// <summary>
        /// 列内のコントロールのデフォルトMappingName
        /// </summary>
        public string DefaultMappingName { get; set; }

        /// <summary>
        /// ソートできるかどうか
        /// </summary>
        public bool AllowSorting
        {
            get { return _allowSorting; }
            set { _allowSorting = value; }
        }
        private bool _allowSorting = true;

        /// <summary>
        /// Initialize
        /// </summary>
        /// <param name="sortingEnabled"></param>
        /// <param name="control"></param>
        /// <returns></returns>
        public override bool Initialize(bool sortingEnabled, System.Web.UI.Control control)
        {
            //SortExpressionにデフォルト値をセット
            if (sortingEnabled == true)
            {
                if (this.AllowSorting == false)
                {
                    sortingEnabled = false;
                }
                else if (this.SortExpression.IsEmpty() == true && this.DefaultMappingName.IsNotBlank() == true)
                {
                    this.SortExpression = this.DefaultMappingName;
                }
            }

            //ローカライズ
            if (this.HeaderLTextKey.IsNotBlank())
            {
                base.HeaderText = LTextMgr.GetText(this.HeaderLTextKey);
            }
            if (this.FooterLTextKey.IsNotBlank())
            {
                base.FooterText = LTextMgr.GetText(this.FooterLTextKey);
            }

            return base.Initialize(sortingEnabled, control);
        }

        /// <summary>
        /// InitializeCell
        /// </summary>
        /// <param name="cell"></param>
        /// <param name="cellType"></param>
        /// <param name="rowState"></param>
        /// <param name="rowIndex"></param>
        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex)
        {
            //InitializeCell
            base.InitializeCell(cell, cellType, rowState, rowIndex);

            //セル内のIMappingControlのMappingNameにDefaultMappingNameをセットする
            if (this.DefaultMappingName.IsNotBlank() == true)
            {
                foreach (System.Web.UI.Control c in cell.Controls)
                {
                    var mc = c as IMappingControl;
                    if (mc != null)
                    {
                        if (mc.MappingName.IsEmpty() == true)
                        {
                            mc.MappingName = this.DefaultMappingName;
                        }
                    }
                }
            }

        }
    }
}
